<Query Kind="Program">
  <Namespace>System.Net</Namespace>
  <Namespace>System.Threading.Tasks</Namespace>
  <Namespace>System.Runtime.InteropServices</Namespace>
</Query>

static void Main()
{
	// Nasłuchuje na porcie 51111, serwije pliki z d:\webroot:
	var server = new WebServer ("http://localhost:51111/", Path.Combine(TempDirectory, "webroot"));
	try
	{
		server.Start();
		// W LINQPad zatrzymaj zapytanie ręcznie:
		Console.WriteLine ("Server running... press Enter to stop");
		Console.ReadLine();
	}
	finally { server.Stop(); }
}


class WebServer
{
	HttpListener _listener;
	string _baseFolder;      // folder Twojej strony

	public WebServer (string uriPrefix, string baseFolder)
	{
		_listener = new HttpListener();
		_listener.Prefixes.Add (uriPrefix);
		_baseFolder = baseFolder;
	}

	public async void Start()
	{
		_listener.Start();
		while (true)
			try
			{
				var context = await _listener.GetContextAsync();
				Task.Run (() => ProcessRequestAsync (context));
			}
			catch (HttpListenerException) { break; }   // nasłuchiwacz zatrzymany
			catch (InvalidOperationException) { break; }   // nasłuchiwacz zatrzymany
	}

	public void Stop() { _listener.Stop(); }

	async void ProcessRequestAsync (HttpListenerContext context)
	{
		try
		{
			string filename = Path.GetFileName (context.Request.RawUrl);
			string path = Path.Combine (_baseFolder, filename);
			byte[] msg;
			if (!File.Exists (path))
			{
				Console.WriteLine ("Nie znaleziono zasobu: " + path);
				context.Response.StatusCode = (int)HttpStatusCode.NotFound;
				msg = Encoding.UTF8.GetBytes ("Niestety, ta strona nie istnieje");
			}
			else
			{
				context.Response.StatusCode = (int)HttpStatusCode.OK;
				msg = File.ReadAllBytes (path);
			}
			context.Response.ContentLength64 = msg.Length;
			using (Stream s = context.Response.OutputStream)
				await s.WriteAsync (msg, 0, msg.Length);
		}
		catch (Exception ex) { Console.WriteLine ("Błąd żądania: " + ex); }
	}
}
static string TempDirectory
{
	get => RuntimeInformation.IsOSPlatform (OSPlatform.Windows) ?
            @"C:\Temp" : "/tmp";
}